<div>
    <!-- Filtres -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Filtres Kanban</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label for="project" class="block text-sm font-medium text-gray-700">Projet</label>
                    <select wire:model.live="selectedProject" id="project" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="">Tous les projets</option>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = \App\Models\Project::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->title); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </select>
                </div>

                <div>
                    <label for="user" class="block text-sm font-medium text-gray-700">Utilisateur</label>
                    <select wire:model.live="selectedUser" id="user" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <option value="">Tous les utilisateurs</option>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </select>
                </div>

                <div>
                    <label for="week" class="block text-sm font-medium text-gray-700">Semaine</label>
                    <input wire:model.live="selectedWeek" type="date" id="week" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                </div>
            </div>
        </div>
    </div>

    <!-- Tableau Kanban -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6" x-data="kanbanDragDrop()">
        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $kanbanData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $tasks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-lg shadow-sm border">
                <div class="p-4 border-b">
                    <h3 class="text-lg font-semibold text-gray-900">
                        <?php echo e($status); ?>

                        <span class="ml-2 bg-gray-100 text-gray-600 px-2 py-1 rounded-full text-sm">
                            <?php echo e($tasks->count()); ?>

                        </span>
                    </h3>
                </div>
                <div class="p-4 space-y-3 min-h-96" 
                     data-status="<?php echo e($status); ?>"
                     @dragover.prevent
                     @drop="handleDrop($event, '<?php echo e($status); ?>')"
                     :class="{ 'bg-blue-50 border-2 border-blue-200 border-dashed': isDragOver }"
                     @dragenter="isDragOver = true"
                     @dragleave="isDragOver = false">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="bg-gray-50 rounded-lg p-4 border-l-4 cursor-move transition-all duration-200 hover:shadow-md
                            <?php if($task->priority === 'Haute'): ?> border-red-500
                            <?php elseif($task->priority === 'Moyenne'): ?> border-yellow-500
                            <?php else: ?> border-green-500
                            <?php endif; ?>"
                             draggable="true"
                             data-task-id="<?php echo e($task->id); ?>"
                             @dragstart="handleDragStart($event, <?php echo e($task->id); ?>)"
                             @dragend="handleDragEnd()">
                            <div class="flex justify-between items-start mb-2">
                                <h4 class="font-medium text-gray-900 text-sm"><?php echo e($task->title); ?></h4>
                                <span class="text-xs text-gray-500"><?php echo e($task->week->format('d/m')); ?></span>
                            </div>
                            <p class="text-xs text-gray-600 mb-2"><?php echo e($task->project->title); ?></p>
                            <p class="text-xs text-gray-500 mb-3">Assigné à: <?php echo e($task->user->name); ?></p>
                            
                            <div class="flex justify-between items-center">
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                    <?php if($task->priority === 'Haute'): ?> bg-red-100 text-red-800
                                    <?php elseif($task->priority === 'Moyenne'): ?> bg-yellow-100 text-yellow-800
                                    <?php else: ?> bg-green-100 text-green-800
                                    <?php endif; ?>">
                                    <?php echo e($task->priority); ?>

                                </span>
                                
                                <div class="flex space-x-1">
                                    <button wire:click="updateTaskStatus(<?php echo e($task->id); ?>, '<?php echo e($status === 'À faire' ? 'En cours' : ($status === 'En cours' ? 'Terminé' : 'À faire')); ?>')"
                                            class="text-xs bg-blue-500 hover:bg-blue-600 text-white px-2 py-1 rounded">
                                        →
                                    </button>
                                </div>
                            </div>
                            
                            <!--[if BLOCK]><![endif]--><?php if($task->blockage): ?>
                                <div class="mt-2 p-2 bg-red-50 rounded text-xs text-red-700">
                                    <strong>Blocage:</strong> <?php echo e($task->blockage); ?>

                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!--[if BLOCK]><![endif]--><?php if($task->next_action): ?>
                                <div class="mt-2 p-2 bg-blue-50 rounded text-xs text-blue-700">
                                    <strong>Prochaine action:</strong> <?php echo e($task->next_action); ?>

                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <script>
        function kanbanDragDrop() {
            return {
                draggedTaskId: null,
                isDragOver: false,
                
                handleDragStart(event, taskId) {
                    this.draggedTaskId = taskId;
                    event.dataTransfer.effectAllowed = 'move';
                    event.dataTransfer.setData('text/html', event.target.outerHTML);
                    event.target.style.opacity = '0.5';
                },
                
                handleDragEnd() {
                    this.draggedTaskId = null;
                    this.isDragOver = false;
                    // Restaurer l'opacité de tous les éléments
                    document.querySelectorAll('[draggable="true"]').forEach(el => {
                        el.style.opacity = '1';
                    });
                },
                
                handleDrop(event, newStatus) {
                    event.preventDefault();
                    this.isDragOver = false;
                    
                    if (this.draggedTaskId) {
                        // Appeler la méthode Livewire pour mettre à jour le statut
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').updateTaskStatusByDrag(this.draggedTaskId, newStatus);
                        
                        // Afficher une notification de succès
                        this.showNotification('Tâche déplacée avec succès !');
                    }
                },
                
                showNotification(message) {
                    // Créer une notification temporaire
                    const notification = document.createElement('div');
                    notification.className = 'fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50';
                    notification.textContent = message;
                    document.body.appendChild(notification);
                    
                    // Supprimer la notification après 3 secondes
                    setTimeout(() => {
                        notification.remove();
                    }, 3000);
                }
            }
        }
    </script>
</div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/team-bbs-master/resources/views/livewire/task-kanban.blade.php ENDPATH**/ ?>