<div>
    <!-- Navigation des semaines -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <div class="flex justify-between items-center">
                <button wire:click="previousWeek" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                    ← Semaine précédente
                </button>
                
                <div class="text-center">
                    <h3 class="text-lg font-semibold text-gray-900">
                        Semaine du <?php echo e(\Carbon\Carbon::parse($currentWeek)->format('d/m/Y')); ?>

                    </h3>
                    <p class="text-sm text-gray-600">
                        <?php echo e(\Carbon\Carbon::parse($currentWeek)->startOfWeek()->format('d/m/Y')); ?> - 
                        <?php echo e(\Carbon\Carbon::parse($currentWeek)->endOfWeek()->format('d/m/Y')); ?>

                    </p>
                </div>
                
                <button wire:click="nextWeek" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                    Semaine suivante →
                </button>
            </div>
        </div>
    </div>

    <!-- Bouton pour ajouter une nouvelle tâche -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-900">Planification des tâches</h3>
                <button wire:click="showAddTaskModal" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    + Ajouter une tâche pour S+1
                </button>
            </div>
        </div>
    </div>

    <!-- Projets groupés par responsable -->
    <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6 mb-8">
        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $projectsByResponsible; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $responsibleName => $projects): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-lg shadow-sm border">
                <div class="p-4 border-b bg-gray-50">
                    <div class="flex justify-between items-center">
                        
                        <h3 class="text-lg font-semibold text-gray-900"><?php echo e($responsibleName); ?></h3>
                        <button  wire:click="quickAddTask('<?php echo e($responsibleName); ?>')" class="text-blue-600 hover:text-blue-800 text-xs font-medium">
                            + Tâche
                        </button>
                    </div>
                    <p class="text-sm text-gray-600"><?php echo e($projects->count()); ?> projet(s)</p>
                </div>
                <div class="p-4 space-y-3">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="border rounded-lg p-3 bg-white hover:bg-gray-50 transition-colors">
                            <div class="flex justify-between items-start mb-2">
                                <h4 class="font-medium text-gray-900 text-sm"><?php echo e($project->title); ?></h4>
                                
                            </div>
                            
                            <!--[if BLOCK]><![endif]--><?php if($project->description): ?>
                                <p class="text-xs text-gray-600 mb-2"><?php echo e(Str::limit($project->description, 100)); ?></p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!-- Tâches existantes pour cette semaine -->
                            <?php
                                $projectTasks = $weeklyData->flatten()->where('project_id', $project->id);
                            ?>
                            
                            <!--[if BLOCK]><![endif]--><?php if($projectTasks->count() > 0): ?>
                                <div class="mt-3 space-y-2">
                                    <p class="text-xs font-medium text-gray-700">Tâches cette semaine:</p>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $projectTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="text-xs p-2 rounded bg-gray-100">
                                            <div class="flex justify-between items-center">
                                                <span class="font-medium"><?php echo e($task->title); ?></span>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                    <?php if($task->status === 'Terminé'): ?> bg-green-100 text-green-800
                                                    <?php elseif($task->status === 'En cours'): ?> bg-blue-100 text-blue-800
                                                    <?php elseif($task->status === 'Bloqué'): ?> bg-red-100 text-red-800
                                                    <?php else: ?> bg-gray-100 text-gray-800
                                                    <?php endif; ?>">
                                                    <?php echo e($task->status); ?>

                                                </span>
                                            </div>
                                            <div class="text-gray-600 mt-1"><?php echo e($task->user->name); ?></div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Tâches par utilisateur pour la semaine actuelle -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Tâches de la semaine actuelle</h3>
            
            <!--[if BLOCK]><![endif]--><?php if($weeklyData->count() > 0): ?>
                <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $weeklyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userName => $tasks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h4 class="font-semibold text-gray-900 mb-3"><?php echo e($userName); ?></h4>
                            <div class="space-y-2">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="border rounded-lg p-3 bg-white
                                        <?php if($task->status === 'Terminé'): ?> border-green-200
                                        <?php elseif($task->status === 'En cours'): ?> border-blue-200
                                        <?php elseif($task->status === 'Bloqué'): ?> border-red-200
                                        <?php else: ?> border-gray-200
                                        <?php endif; ?>">
                                        <div class="flex justify-between items-start mb-2">
                                            <h5 class="font-medium text-gray-900 text-sm"><?php echo e($task->title); ?></h5>
                                            <span class="text-xs text-gray-500"><?php echo e($task->week->format('d/m')); ?></span>
                                        </div>
                                        
                                        <p class="text-xs text-gray-600 mb-2"><?php echo e($task->project->title); ?></p>
                                        
                                        <div class="flex justify-between items-center mb-2">
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                <?php if($task->status === 'Terminé'): ?> bg-green-100 text-green-800
                                                <?php elseif($task->status === 'En cours'): ?> bg-blue-100 text-blue-800
                                                <?php elseif($task->status === 'Bloqué'): ?> bg-red-100 text-red-800
                                                <?php else: ?> bg-gray-100 text-gray-800
                                                <?php endif; ?>">
                                                <?php echo e($task->status); ?>

                                            </span>
                                            
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                <?php if($task->priority === 'Haute'): ?> bg-red-100 text-red-800
                                                <?php elseif($task->priority === 'Moyenne'): ?> bg-yellow-100 text-yellow-800
                                                <?php else: ?> bg-green-100 text-green-800
                                                <?php endif; ?>">
                                                <?php echo e($task->priority); ?>

                                            </span>
                                        </div>
                                        
                                        <!--[if BLOCK]><![endif]--><?php if($task->blockage): ?>
                                            <div class="mt-2 p-2 bg-red-100 rounded text-xs text-red-700">
                                                <strong>Blocage:</strong> <?php echo e($task->blockage); ?>

                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        
                                        <!--[if BLOCK]><![endif]--><?php if($task->next_action): ?>
                                            <div class="mt-2 p-2 bg-blue-100 rounded text-xs text-blue-700">
                                                <strong>Prochaine action:</strong> <?php echo e($task->next_action); ?>

                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <p class="text-gray-500">Aucune tâche trouvée pour cette semaine.</p>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Modal pour ajouter une tâche -->
    <!--[if BLOCK]><![endif]--><?php if($showAddTaskModal): ?>
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                <div class="mt-3">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Ajouter une tâche pour la semaine suivante</h3>
                    
                    <form wire:submit.prevent="addTask" class="space-y-4">
                        <div>
                            <label for="title" class="block text-sm font-medium text-gray-700">Titre de la tâche</label>
                            <input type="text" wire:model="newTask.title" id="title" 
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTask.title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div>
                            <label for="project" class="block text-sm font-medium text-gray-700">Projet</label>
                            <select wire:model="newTask.project_id" id="project" 
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="">Sélectionner un projet</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($project->id); ?>"><?php echo e($project->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTask.project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div>
                            <label for="user" class="block text-sm font-medium text-gray-700">Responsable</label>
                            <select wire:model="newTask.user_id" id="user" disabled
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="">Sélectionner un responsable</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newTask.user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label for="priority" class="block text-sm font-medium text-gray-700">Priorité</label>
                                <select wire:model="newTask.priority" id="priority" 
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="Basse">Basse</option>
                                    <option value="Moyenne">Moyenne</option>
                                    <option value="Haute">Haute</option>
                                </select>
                            </div>

                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700">Statut</label>
                                <select wire:model="newTask.status" id="status" 
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="À faire">À faire</option>
                                    <option value="En cours">En cours</option>
                                    <option value="Terminé">Terminé</option>
                                    <option value="Bloqué">Bloqué</option>
                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="description" class="block text-sm font-medium text-gray-700">Description/Blocage</label>
                            <textarea wire:model="newTask.description" id="description" rows="2"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"></textarea>
                        </div>

                        <div>
                            <label for="next_action" class="block text-sm font-medium text-gray-700">Prochaine action</label>
                            <textarea wire:model="newTask.next_action" id="next_action" rows="2"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"></textarea>
                        </div>

                        <div class="flex justify-end space-x-3 pt-4">
                            <button type="button" wire:click="closeAddTaskModal" 
                                class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded">
                                Annuler
                            </button>
                            <button type="submit" 
                                class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                Ajouter la tâche
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/team-bbs-master/resources/views/livewire/weekly-tasks.blade.php ENDPATH**/ ?>