<?php

use App\Http\Controllers\MeetingNoteController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\TaskController;
use Illuminate\Support\Facades\Route;

Route::view('/', 'welcome');

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    // Routes pour les projets
    Route::resource('projects', ProjectController::class);

    // Routes pour les tâches
    Route::resource('tasks', TaskController::class);

    // Routes pour les notes de réunion
    Route::resource('meeting-notes', MeetingNoteController::class);

    // Routes spéciales pour les vues
    Route::get('/kanban', function () {
        return view('kanban');
    })->name('kanban');

    Route::get('/weekly-tasks', function () {
        return view('weekly-tasks');
    })->name('weekly-tasks');
});

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

require __DIR__.'/auth.php';
