<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Détails de la Tâche - TEAM BBS MASTER') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-semibold text-gray-900">{{ $task->title }}</h3>
                        <a href="{{ route('tasks.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                            Retour
                        </a>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="text-md font-medium text-gray-900 mb-2">Informations générales</h4>
                            <div class="space-y-2">
                                <p><strong>Projet:</strong> {{ $task->project->title }}</p>
                                <p><strong>Assigné à:</strong> {{ $task->user->name }}</p>
                                <p><strong>Semaine:</strong> {{ $task->week->format('d/m/Y') }}</p>
                                <p><strong>Statut:</strong> 
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                        @if($task->status === 'Terminé') bg-green-100 text-green-800
                                        @elseif($task->status === 'En cours') bg-blue-100 text-blue-800
                                        @elseif($task->status === 'Bloqué') bg-red-100 text-red-800
                                        @else bg-gray-100 text-gray-800
                                        @endif">
                                        {{ $task->status }}
                                    </span>
                                </p>
                                <p><strong>Priorité:</strong> 
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                        @if($task->priority === 'Haute') bg-red-100 text-red-800
                                        @elseif($task->priority === 'Moyenne') bg-yellow-100 text-yellow-800
                                        @else bg-green-100 text-green-800
                                        @endif">
                                        {{ $task->priority }}
                                    </span>
                                </p>
                            </div>
                        </div>

                        <div>
                            @if($task->blockage)
                                <h4 class="text-md font-medium text-gray-900 mb-2">Blocage</h4>
                                <div class="bg-red-50 border border-red-200 rounded p-3">
                                    <p class="text-red-700">{{ $task->blockage }}</p>
                                </div>
                            @endif

                            @if($task->next_action)
                                <h4 class="text-md font-medium text-gray-900 mb-2 mt-4">Prochaine action</h4>
                                <div class="bg-blue-50 border border-blue-200 rounded p-3">
                                    <p class="text-blue-700">{{ $task->next_action }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 