<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Détails du Projet - TEAM BBS MASTER') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-semibold text-gray-900">{{ $project->title }}</h3>
                        <a href="{{ route('projects.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                            Retour
                        </a>
                    </div>

                    <div class="mb-6">
                        <h4 class="text-md font-medium text-gray-900 mb-2">Description</h4>
                        <p class="text-gray-600">{{ $project->description ?: 'Aucune description' }}</p>
                    </div>

                    <div class="mb-6">
                        <h4 class="text-md font-medium text-gray-900 mb-2">Tâches associées</h4>
                        @if($project->tasks->count() > 0)
                            <div class="space-y-2">
                                @foreach($project->tasks as $task)
                                    <div class="border rounded p-3">
                                        <div class="flex justify-between items-start">
                                            <div>
                                                <h5 class="font-medium">{{ $task->title }}</h5>
                                                <p class="text-sm text-gray-600">Assigné à: {{ $task->user->name }}</p>
                                                <p class="text-sm text-gray-600">Semaine: {{ $task->week->format('d/m/Y') }}</p>
                                            </div>
                                            <div class="text-right">
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                    @if($task->status === 'Terminé') bg-green-100 text-green-800
                                                    @elseif($task->status === 'En cours') bg-blue-100 text-blue-800
                                                    @elseif($task->status === 'Bloqué') bg-red-100 text-red-800
                                                    @else bg-gray-100 text-gray-800
                                                    @endif">
                                                    {{ $task->status }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <p class="text-gray-500">Aucune tâche associée à ce projet.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 