<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Note de Réunion - TEAM BBS MASTER') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-semibold text-gray-900">Note de réunion du {{ $meetingNote->meeting_date->format('d/m/Y') }}</h3>
                        <a href="{{ route('meeting-notes.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                            Retour
                        </a>
                    </div>

                    <div class="mb-6">
                        <h4 class="text-md font-medium text-gray-900 mb-2">Résumé</h4>
                        <div class="bg-gray-50 border rounded p-4">
                            <p class="text-gray-700 whitespace-pre-wrap">{{ $meetingNote->summary }}</p>
                        </div>
                    </div>

                    <div class="text-sm text-gray-500">
                        <p>Créé le: {{ $meetingNote->created_at->format('d/m/Y à H:i') }}</p>
                        @if($meetingNote->updated_at != $meetingNote->created_at)
                            <p>Modifié le: {{ $meetingNote->updated_at->format('d/m/Y à H:i') }}</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 