<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Nouvelle Note de Réunion - TEAM BBS MASTER') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-semibold text-gray-900">Créer une nouvelle note de réunion</h3>
                        <a href="{{ route('meeting-notes.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                            Retour
                        </a>
                    </div>

                    <form action="{{ route('meeting-notes.store') }}" method="POST">
                        @csrf
                        
                        <div class="mb-4">
                            <x-input-label for="meeting_date" :value="__('Date de réunion')" />
                            <x-text-input id="meeting_date" class="block mt-1 w-full" type="date" name="meeting_date" :value="old('meeting_date')" required autofocus />
                            <x-input-error :messages="$errors->get('meeting_date')" class="mt-2" />
                        </div>

                        <div class="mb-4">
                            <x-input-label for="summary" :value="__('Résumé')" />
                            <textarea id="summary" name="summary" rows="8" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" required>{{ old('summary') }}</textarea>
                            <x-input-error :messages="$errors->get('summary')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button class="ml-4">
                                {{ __('Créer la note') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 