<div>
    <!-- Navigation des semaines -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <div class="flex justify-between items-center">
                <button wire:click="previousWeek" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                    ← Semaine précédente
                </button>
                
                <div class="text-center">
                    <h3 class="text-lg font-semibold text-gray-900">
                        Semaine du {{ \Carbon\Carbon::parse(time: $currentWeek)->format('d/m/Y') }}
                    </h3>
                    <p class="text-sm text-gray-600">
                        {{ \Carbon\Carbon::parse($currentWeek)->startOfWeek()->format('d/m/Y') }} - 
                        {{ \Carbon\Carbon::parse($currentWeek)->endOfWeek()->format('d/m/Y') }}
                    </p>
                </div>
                
                <button wire:click="nextWeek" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                    Semaine suivante →
                </button>
            </div>
        </div>
    </div>

    <!-- Bouton pour ajouter une nouvelle tâche -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-900">Planification des tâches</h3>
                <button wire:click="showAddTaskModal" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    + Ajouter une tâche pour S+1
                </button>
            </div>
        </div>
    </div>

    <!-- Projets groupés par responsable -->
    <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6 mb-8">
        @foreach($projectsByResponsible as $responsibleName => $projects)
            <div class="bg-white rounded-lg shadow-sm border">
                <div class="p-4 border-b bg-gray-50">
                    <div class="flex justify-between items-center">
                        
                        <h3 class="text-lg font-semibold text-gray-900">{{ $responsibleName }}</h3>
                        <button  wire:click="quickAddTask('{{ $responsibleName }}')" class="text-blue-600 hover:text-blue-800 text-xs font-medium">
                            + Tâche
                        </button>
                    </div>
                    <p class="text-sm text-gray-600">{{ $projects->count() }} projet(s)</p>
                </div>
                <div class="p-4 space-y-3">
                    @foreach($projects as $project)
                        <div class="border rounded-lg p-3 bg-white hover:bg-gray-50 transition-colors">
                            <div class="flex justify-between items-start mb-2">
                                <h4 class="font-medium text-gray-900 text-sm">{{ $project->title }}</h4>
                                
                            </div>
                            
                            @if($project->description)
                                <p class="text-xs text-gray-600 mb-2">{{ Str::limit($project->description, 100) }}</p>
                            @endif
                            
                            <!-- Tâches existantes pour cette semaine -->
                            @php
                                $projectTasks = $weeklyData->flatten()->where('project_id', $project->id);
                            @endphp
                            
                            @if($projectTasks->count() > 0)
                                <div class="mt-3 space-y-2">
                                    <p class="text-xs font-medium text-gray-700">Tâches cette semaine:</p>
                                    @foreach($projectTasks as $task)
                                        <div class="text-xs p-2 rounded bg-gray-100">
                                            <div class="flex justify-between items-center">
                                                <span class="font-medium">{{ $task->title }}</span>
                                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                    @if($task->status === 'Terminé') bg-green-100 text-green-800
                                                    @elseif($task->status === 'En cours') bg-blue-100 text-blue-800
                                                    @elseif($task->status === 'Bloqué') bg-red-100 text-red-800
                                                    @else bg-gray-100 text-gray-800
                                                    @endif">
                                                    {{ $task->status }}
                                                </span>
                                            </div>
                                            <div class="text-gray-600 mt-1">{{ $task->user->name }}</div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>

    <!-- Tâches par utilisateur pour la semaine actuelle -->
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Tâches de la semaine actuelle</h3>
            
            @if($weeklyData->count() > 0)
                <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6">
                    @foreach($weeklyData as $userName => $tasks)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h4 class="font-semibold text-gray-900 mb-3">{{ $userName }}</h4>
                            <div class="space-y-2">
                                @foreach($tasks as $task)
                                    <div class="border rounded-lg p-3 bg-white
                                        @if($task->status === 'Terminé') border-green-200
                                        @elseif($task->status === 'En cours') border-blue-200
                                        @elseif($task->status === 'Bloqué') border-red-200
                                        @else border-gray-200
                                        @endif">
                                        <div class="flex justify-between items-start mb-2">
                                            <h5 class="font-medium text-gray-900 text-sm">{{ $task->title }}</h5>
                                            <span class="text-xs text-gray-500">{{ $task->week->format('d/m') }}</span>
                                        </div>
                                        
                                        <p class="text-xs text-gray-600 mb-2">{{ $task->project->title }}</p>
                                        
                                        <div class="flex justify-between items-center mb-2">
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                @if($task->status === 'Terminé') bg-green-100 text-green-800
                                                @elseif($task->status === 'En cours') bg-blue-100 text-blue-800
                                                @elseif($task->status === 'Bloqué') bg-red-100 text-red-800
                                                @else bg-gray-100 text-gray-800
                                                @endif">
                                                {{ $task->status }}
                                            </span>
                                            
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                @if($task->priority === 'Haute') bg-red-100 text-red-800
                                                @elseif($task->priority === 'Moyenne') bg-yellow-100 text-yellow-800
                                                @else bg-green-100 text-green-800
                                                @endif">
                                                {{ $task->priority }}
                                            </span>
                                        </div>
                                        
                                        @if($task->blockage)
                                            <div class="mt-2 p-2 bg-red-100 rounded text-xs text-red-700">
                                                <strong>Blocage:</strong> {{ $task->blockage }}
                                            </div>
                                        @endif
                                        
                                        @if($task->next_action)
                                            <div class="mt-2 p-2 bg-blue-100 rounded text-xs text-blue-700">
                                                <strong>Prochaine action:</strong> {{ $task->next_action }}
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-8">
                    <p class="text-gray-500">Aucune tâche trouvée pour cette semaine.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Modal pour ajouter une tâche -->
    @if($showAddTaskModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                <div class="mt-3">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Ajouter une tâche pour la semaine suivante</h3>
                    
                    <form wire:submit.prevent="addTask" class="space-y-4">
                        <div>
                            <label for="title" class="block text-sm font-medium text-gray-700">Titre de la tâche</label>
                            <input type="text" wire:model="newTask.title" id="title" 
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            @error('newTask.title') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label for="project" class="block text-sm font-medium text-gray-700">Projet</label>
                            <select wire:model="newTask.project_id" id="project" 
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="">Sélectionner un projet</option>
                                @foreach($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->title }}</option>
                                @endforeach
                            </select>
                            @error('newTask.project_id') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label for="user" class="block text-sm font-medium text-gray-700">Responsable</label>
                            <select wire:model="newTask.user_id" id="user" disabled
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="">Sélectionner un responsable</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                            @error('newTask.user_id') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label for="priority" class="block text-sm font-medium text-gray-700">Priorité</label>
                                <select wire:model="newTask.priority" id="priority" 
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="Basse">Basse</option>
                                    <option value="Moyenne">Moyenne</option>
                                    <option value="Haute">Haute</option>
                                </select>
                            </div>

                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700">Statut</label>
                                <select wire:model="newTask.status" id="status" 
                                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="À faire">À faire</option>
                                    <option value="En cours">En cours</option>
                                    <option value="Terminé">Terminé</option>
                                    <option value="Bloqué">Bloqué</option>
                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="description" class="block text-sm font-medium text-gray-700">Description/Blocage</label>
                            <textarea wire:model="newTask.description" id="description" rows="2"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"></textarea>
                        </div>

                        <div>
                            <label for="next_action" class="block text-sm font-medium text-gray-700">Prochaine action</label>
                            <textarea wire:model="newTask.next_action" id="next_action" rows="2"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"></textarea>
                        </div>

                        <div class="flex justify-end space-x-3 pt-4">
                            <button type="button" wire:click="closeAddTaskModal" 
                                class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded">
                                Annuler
                            </button>
                            <button type="submit" 
                                class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                Ajouter la tâche
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
</div>
