<?php

namespace Database\Seeders;

use App\Models\Project;
use App\Models\Task;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TaskSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $projects = Project::all();
        $users = User::all();
        
        // Vérifier qu'il y a des utilisateurs et des projets
        if ($users->isEmpty()) {
            throw new \Exception('Aucun utilisateur trouvé. Assurez-vous que TeamMembersSeeder a été exécuté.');
        }
        
        if ($projects->isEmpty()) {
            throw new \Exception('Aucun projet trouvé. Assurez-vous que ProjectSeeder a été exécuté.');
        }
        
        $statuses = ['À faire', 'En cours', 'Terminé', 'Bloqué'];
        $priorities = ['Haute', 'Moyenne', 'Basse'];

        $tasks = [
            [
                'title' => 'Créer la maquette du design',
                'project_id' => $projects->first()->id,
                'user_id' => $users->first()->id,
                'week' => now()->addWeek(),
                'status' => 'En cours',
                'priority' => 'Haute',
                'blockage' => 'En attente de validation du client',
                'next_action' => 'Finaliser les wireframes',
            ],
            [
                'title' => 'Développer l\'API backend',
                'project_id' => $projects->count() > 1 ? $projects->get(1)->id : $projects->first()->id,
                'user_id' => $users->count() > 1 ? $users->get(1)->id : $users->first()->id,
                'week' => now()->addWeek(),
                'status' => 'À faire',
                'priority' => 'Haute',
                'blockage' => null,
                'next_action' => 'Créer les endpoints REST',
            ],
            [
                'title' => 'Tests unitaires',
                'project_id' => $projects->count() > 2 ? $projects->get(2)->id : $projects->first()->id,
                'user_id' => $users->count() > 2 ? $users->get(2)->id : $users->first()->id,
                'week' => now(),
                'status' => 'Terminé',
                'priority' => 'Moyenne',
                'blockage' => null,
                'next_action' => 'Tests d\'intégration',
            ],
            [
                'title' => 'Documentation technique',
                'project_id' => $projects->count() > 3 ? $projects->get(3)->id : $projects->first()->id,
                'user_id' => $users->count() > 3 ? $users->get(3)->id : $users->first()->id,
                'week' => now()->addWeeks(2),
                'status' => 'Bloqué',
                'priority' => 'Basse',
                'blockage' => 'Manque d\'informations sur les spécifications',
                'next_action' => 'Contacter le chef de projet',
            ],
            [
                'title' => 'Optimisation des performances',
                'project_id' => $projects->first()->id,
                'user_id' => $users->count() > 4 ? $users->get(4)->id : $users->first()->id,
                'week' => now()->addWeek(),
                'status' => 'À faire',
                'priority' => 'Moyenne',
                'blockage' => null,
                'next_action' => 'Analyser les métriques',
            ],
            [
                'title' => 'Déploiement en production',
                'project_id' => $projects->count() > 1 ? $projects->get(1)->id : $projects->first()->id,
                'user_id' => $users->count() > 5 ? $users->get(5)->id : $users->first()->id,
                'week' => now()->addWeeks(3),
                'status' => 'À faire',
                'priority' => 'Haute',
                'blockage' => null,
                'next_action' => 'Préparer l\'environnement',
            ],
        ];

        foreach ($tasks as $taskData) {
            Task::create($taskData);
        }
    }
}
