<?php

namespace Database\Seeders;

use App\Models\Project;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $projects = [
            [
                'title' => 'Refonte du site web',
                'description' => 'Modernisation complète du site web de l\'entreprise avec une nouvelle interface utilisateur.',
            ],
            [
                'title' => 'Application mobile',
                'description' => 'Développement d\'une application mobile pour iOS et Android.',
            ],
            [
                'title' => 'Système de gestion des stocks',
                'description' => 'Création d\'un système automatisé pour la gestion des stocks et des commandes.',
            ],
            [
                'title' => 'API REST',
                'description' => 'Développement d\'une API REST pour l\'intégration avec des services tiers.',
            ],
        ];

        foreach ($projects as $project) {
            Project::create($project);
        }
    }
}
