<?php

namespace Database\Seeders;

use App\Models\MeetingNote;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MeetingNoteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $meetingNotes = [
            [
                'meeting_date' => now()->subDays(7),
                'summary' => "Réunion hebdomadaire de l'équipe TEAM BBS MASTER

Points abordés :
- Revue des tâches en cours
- Discussion sur les blocages rencontrés
- Planification de la semaine prochaine

Décisions prises :
- Prioriser le développement de l'API backend
- Organiser une session de formation sur les nouvelles technologies
- Mettre en place un système de suivi des performances

Actions à suivre :
- Pape Toulé : Finaliser la maquette du design
- Malick : Commencer les tests unitaires
- Libasse : Préparer la documentation technique",
            ],
            [
                'meeting_date' => now()->subDays(14),
                'summary' => "Réunion de lancement du projet 'Refonte du site web'

Participants : Toute l'équipe TEAM BBS MASTER

Objectifs du projet :
- Moderniser l'interface utilisateur
- Améliorer les performances
- Optimiser l'expérience utilisateur

Répartition des tâches :
- Pape Samba : Architecture technique
- Magor : Développement frontend
- Ibra Ndiaye : Tests et qualité

Prochaine réunion : Dans 2 semaines pour la revue de mi-parcours",
            ],
            [
                'meeting_date' => now()->subDays(21),
                'summary' => "Réunion de rétrospective

Points positifs :
- Bonne collaboration entre les membres de l'équipe
- Respect des délais sur la plupart des tâches
- Communication efficace

Points d'amélioration :
- Besoin de plus de documentation
- Optimiser le processus de déploiement
- Améliorer la gestion des priorités

Actions d'amélioration :
- Mettre en place un système de documentation centralisé
- Automatiser le processus de déploiement
- Réviser la méthodologie de gestion des priorités",
            ],
        ];

        foreach ($meetingNotes as $noteData) {
            MeetingNote::create($noteData);
        }
    }
}
