<?php

namespace App\Livewire;

use App\Models\Task;
use Livewire\Component;

class TaskKanban extends Component
{
    public $selectedProject = '';
    public $selectedUser = '';
    public $selectedWeek = '';

    public function render()
    {
        $query = Task::with(['project', 'user']);

        if ($this->selectedProject) {
            $query->where('project_id', $this->selectedProject);
        }

        if ($this->selectedUser) {
            $query->where('user_id', $this->selectedUser);
        }

        if ($this->selectedWeek) {
            $query->where('week', $this->selectedWeek);
        }

        $tasks = $query->get();

        $kanbanData = [
            'À faire' => $tasks->where('status', 'À faire'),
            'En cours' => $tasks->where('status', 'En cours'),
            'Terminé' => $tasks->where('status', 'Terminé'),
            'Bloqué' => $tasks->where('status', 'Bloqué'),
        ];

        return view('livewire.task-kanban', [
            'kanbanData' => $kanbanData,
        ]);
    }

    public function updateTaskStatus($taskId, $newStatus)
    {
        $task = Task::find($taskId);
        if ($task) {
            $task->update(['status' => $newStatus]);
        }
    }

    public function updateTaskStatusByDrag($taskId, $newStatus)
    {
        $task = Task::find($taskId);
        if ($task) {
            $task->update(['status' => $newStatus]);
            $this->dispatch('task-updated');
        }
    }
}
