<?php

namespace App\Livewire;

use App\Models\Project;
use App\Models\Task;
use App\Models\User;
use Livewire\Component;
use Livewire\WithPagination;

class Dashboard extends Component
{
    use WithPagination;

    public $selectedProject = '';
    public $selectedUser = '';
    public $selectedWeek = '';
    public $selectedStatus = '';

    public function render()
    {
        $query = Task::with(['project', 'user']);

        if ($this->selectedProject) {
            $query->where('project_id', $this->selectedProject);
        }

        if ($this->selectedUser) {
            $query->where('user_id', $this->selectedUser);
        }

        if ($this->selectedWeek) {
            $query->where('week', $this->selectedWeek);
        }

        if ($this->selectedStatus) {
            $query->where('status', $this->selectedStatus);
        }

        $tasks = $query->orderBy('created_at', 'desc')->paginate(10);
        $projects = Project::all();
        $users = User::all();
        $statuses = ['À faire', 'En cours', 'Terminé', 'Bloqué'];

        return view('livewire.dashboard', [
            'tasks' => $tasks,
            'projects' => $projects,
            'users' => $users,
            'statuses' => $statuses,
        ]);
    }

    public function updatedSelectedProject()
    {
        $this->resetPage();
    }

    public function updatedSelectedUser()
    {
        $this->resetPage();
    }

    public function updatedSelectedWeek()
    {
        $this->resetPage();
    }

    public function updatedSelectedStatus()
    {
        $this->resetPage();
    }
}
