<?php

namespace App\Http\Controllers;

use App\Models\MeetingNote;
use Illuminate\Http\Request;

class MeetingNoteController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $meetingNotes = MeetingNote::orderBy('meeting_date', 'desc')->paginate(10);
        return view('meeting-notes.index', compact('meetingNotes'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('meeting-notes.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'meeting_date' => 'required|date',
            'summary' => 'required|string',
        ]);

        MeetingNote::create($request->all());

        return redirect()->route('meeting-notes.index')
            ->with('success', 'Note de réunion créée avec succès.');
    }

    /**
     * Display the specified resource.
     */
    public function show(MeetingNote $meetingNote)
    {
        return view('meeting-notes.show', compact('meetingNote'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MeetingNote $meetingNote)
    {
        return view('meeting-notes.edit', compact('meetingNote'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, MeetingNote $meetingNote)
    {
        $request->validate([
            'meeting_date' => 'required|date',
            'summary' => 'required|string',
        ]);

        $meetingNote->update($request->all());

        return redirect()->route('meeting-notes.index')
            ->with('success', 'Note de réunion mise à jour avec succès.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(MeetingNote $meetingNote)
    {
        $meetingNote->delete();

        return redirect()->route('meeting-notes.index')
            ->with('success', 'Note de réunion supprimée avec succès.');
    }
}
