# TEAM BBS MASTER - Gestion de Projet MVP

Application de gestion de projet développée pour l'équipe **TEAM BBS MASTER** avec Laravel 11, Livewire et Tailwind CSS.

## 🚀 Stack Technologique

- **Backend** : Laravel 11
- **Frontend** : Livewire 3 + Tailwind CSS
- **Authentification** : Laravel Breeze
- **Base de données** : MySQL
- **Interface** : Dashboard moderne avec composants Livewire

## 📦 Fonctionnalités

### 🔐 Authentification
- Système d'authentification complet avec Laravel Breeze
- Gestion des utilisateurs avec rôles

### 👥 Gestion des Utilisateurs
- 6 membres de l'équipe pré-configurés :
  - Pape Toulé
  - Pape Samba
  - Malick
  - Libasse
  - Magor
  - Ibra Ndiaye

### 📋 Gestion des Projets
- CRUD complet des projets
- Titre et description
- Association avec les tâches

### ✅ Gestion des Tâches
- CRUD complet des tâches
- Attribution à un projet et un utilisateur
- Gestion des semaines
- Statuts : À faire, En cours, Terminé, Bloqué
- Priorités : Haute, Moyenne, Basse
- Gestion des blocages et prochaines actions

### 📝 Notes de Réunion
- CRUD complet des notes de réunion
- Date de réunion et résumé détaillé
- Historique des réunions

### 🎯 Interfaces Spécialisées

#### Dashboard Principal
- Vue d'ensemble des tâches
- Filtres avancés (projet, utilisateur, semaine, statut)
- Tableau paginé avec actions rapides

#### Tableau Kanban
- Vue Kanban interactive avec Livewire
- Glisser-déposer des tâches entre statuts
- Filtres par projet, utilisateur et semaine
- Affichage des blocages et prochaines actions

#### Vue Hebdomadaire
- Navigation entre les semaines
- Groupement par utilisateur
- Vue d'ensemble des tâches de la semaine
- Filtres par projet

## 🛠️ Installation

### Prérequis
- PHP 8.2+
- Composer
- MySQL
- Node.js et npm

### Étapes d'installation

1. **Cloner le projet**
```bash
git clone <repository-url>
cd team-bbs-master
```

2. **Installer les dépendances PHP**
```bash
composer install
```

3. **Installer les dépendances Node.js**
```bash
npm install
```

4. **Configurer l'environnement**
```bash
cp .env.example .env
php artisan key:generate
```

5. **Configurer la base de données**
```bash
# Modifier le fichier .env avec vos paramètres de base de données
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=team_bbs_master
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

6. **Exécuter les migrations**
```bash
php artisan migrate
```

7. **Exécuter les seeders**
```bash
php artisan db:seed --class=TeamMembersSeeder
php artisan db:seed --class=ProjectSeeder
php artisan db:seed --class=TaskSeeder
php artisan db:seed --class=MeetingNoteSeeder
```

8. **Compiler les assets**
```bash
npm run build
```

9. **Démarrer le serveur**
```bash
php artisan serve
```

## 👤 Comptes de Test

Les 6 membres de l'équipe sont créés automatiquement avec les identifiants suivants :

| Nom | Email | Mot de passe |
|-----|-------|--------------|
| Pape Toulé | pape.toule@teambbsmaster.com | password |
| Pape Samba | pape.samba@teambbsmaster.com | password |
| Malick | malick@teambbsmaster.com | password |
| Libasse | libasse@teambbsmaster.com | password |
| Magor | magor@teambbsmaster.com | password |
| Ibra Ndiaye | ibra.ndiaye@teambbsmaster.com | password |

## 🗂️ Structure du Projet

```
team-bbs-master/
├── app/
│   ├── Http/Controllers/
│   │   ├── ProjectController.php
│   │   ├── TaskController.php
│   │   └── MeetingNoteController.php
│   ├── Livewire/
│   │   ├── Dashboard.php
│   │   ├── TaskKanban.php
│   │   └── WeeklyTasks.php
│   └── Models/
│       ├── Project.php
│       ├── Task.php
│       ├── MeetingNote.php
│       └── User.php
├── database/
│   ├── migrations/
│   └── seeders/
├── resources/
│   └── views/
│       ├── livewire/
│       ├── projects/
│       ├── tasks/
│       └── meeting-notes/
└── routes/
    └── web.php
```

## 🎨 Fonctionnalités Livewire

### Dashboard
- Filtres en temps réel
- Pagination dynamique
- Mise à jour automatique des données

### Kanban
- Glisser-déposer des tâches
- Mise à jour instantanée des statuts
- Filtres interactifs

### Vue Hebdomadaire
- Navigation entre semaines
- Groupement dynamique par utilisateur
- Filtres par projet

## 🔧 Commandes Utiles

```bash
# Créer un nouveau projet
php artisan make:project

# Créer une nouvelle tâche
php artisan make:task

# Créer une note de réunion
php artisan make:meeting-note

# Vider la base de données et re-seeder
php artisan migrate:fresh --seed

# Compiler les assets en mode développement
npm run dev

# Compiler les assets pour la production
npm run build
```

## 📱 Responsive Design

L'application est entièrement responsive et s'adapte à tous les écrans :
- Desktop : Interface complète avec sidebar
- Tablet : Adaptation des grilles et navigation
- Mobile : Interface optimisée pour les petits écrans

## 🎯 Prochaines Évolutions

- [ ] Notifications en temps réel
- [ ] Export PDF des rapports
- [ ] Intégration avec des outils externes
- [ ] Système de commentaires sur les tâches
- [ ] Gestion des fichiers attachés
- [ ] API REST pour intégrations
- [ ] Système de notifications par email

## 🤝 Contribution

Pour contribuer au projet :

1. Fork le repository
2. Créer une branche pour votre fonctionnalité
3. Commiter vos changements
4. Pousser vers la branche
5. Ouvrir une Pull Request

## 📄 Licence

Ce projet est développé pour l'équipe TEAM BBS MASTER.

---

**TEAM BBS MASTER** - Gestion de projet moderne et efficace 🚀
