<div>
    @if (session()->has('message'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4" role="alert">
            <span class="block sm:inline">{{ session('message') }}</span>
        </div>
    @endif

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <div class="flex justify-between items-center">
                <button wire:click="previousWeek"
                    class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                    ← Semaine précédente
                </button>

                <div class="text-center">
                    <h3 class="text-lg font-semibold text-gray-900">
                        Semaine du {{ \Carbon\Carbon::parse($currentWeek)->format('d/m/Y') }}
                    </h3>
                    <p class="text-sm text-gray-600">
                        {{ \Carbon\Carbon::parse($currentWeek)->startOfWeek()->format('d/m/Y') }} -
                        {{ \Carbon\Carbon::parse($currentWeek)->endOfWeek()->format('d/m/Y') }}
                    </p>
                </div>

                <button wire:click="nextWeek"
                    class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                    Semaine suivante →
                </button>
            </div>
        </div>
    </div>
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
        <div class="p-6">
            <div class="flex justify-between items-center">
                <h2 class="text-lg font-semibold text-gray-900">
                    Tâches de la semaine
                </h2>
            </div>
            <div class="flex flex-wrap bg-gray-100 p-4">
                @foreach ($groupedUserTasks as $userName => $userProjects)
                    <div class="w-full md:w-1/3 p-4">
                        <div class="bg-white rounded-lg shadow-md p-6 h-full flex flex-col">
                            <div class="flex justify-between items-center">
                                <h3 class="text-xl font-bold text-gray-900 mb-4">{{ $userName }}</h3>
                                <button class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded"
                                    wire:click="openAddTaskModal('{{ $userName }}')">
                                    <x-lucide-plus class="w-4 h-4" />
                                </button>
                            </div>
                            @foreach ($userProjects as $project => $tasks)
                                <div class="mb-4">
                                    @if ($project !== 'Autres')
                                        <h4
                                            class="text-md font-semibold text-blue-700 mb-2 border-b border-gray-200 pb-1">
                                            {{ $project }}</h4>
                                    @else
                                        <h4
                                            class="text-md font-semibold text-red-700 mb-2 border-b border-gray-200 pb-1">
                                            {{ $project }}</h4>
                                    @endif
                                    @if (!empty($tasks['tasks']))
                                        <ul class="space-y-2">
                                            @foreach ($tasks['tasks'] as $task)
                                                <li
                                                    class="flex flex-col items-center justify-between px-2 py-1 rounded hover:bg-gray-50 transition">
                                                    <div class="flex items-center justify-between w-full">
                                                        <span class="text-sm text-gray-800">{{ $task['title'] }}</span>
                                                        
                                                       
                                                        <span class="ml-2">
                                                            <select
                                                                wire:change="changeTaskStatus({{ $task['id'] }}, $event.target.value)"
                                                                class="px-2 py-0.5 rounded text-xs font-semibold
                                                                @if ($task['status'] === 'completed' && ($task['date_ok'] >= $startOfWeek && $task['date_ok'] <= $endOfWeek)) bg-green-100 text-green-700
                                                                @elseif($task['status'] === 'in_progress') bg-yellow-100 text-yellow-700
                                                                @else bg-gray-200 text-gray-700 @endif
                                                            "
                                                            @if($startOfWeek > date('Y-m-d') || $endOfWeek < date('Y-m-d'))
                                                                disabled
                                                            @endif
                                                                style="min-width: 110px;">
                                                                <option value="pending"
                                                                    @if ($task['status'] === 'pending') selected @endif>En
                                                                    attente</option>
                                                                <option value="in_progress"
                                                                    @if ($task['status'] === 'in_progress') selected @endif>En
                                                                    cours</option>
                                                                <option value="completed"
                                                                    @if ($task['status'] === 'completed') selected @endif>
                                                                    Terminée</option>
                                                            </select>

                                                        </span>
                                                        

                                                    </div>
                                                    <div>
                                                        @if ($task['status'] === 'completed' && ($task['date_ok'] >= $startOfWeek && $task['date_ok'] <= $endOfWeek))
                                                            <span
                                                                class="text-xs text-gray-400 italic">({{ date('d/m/Y', strtotime($task['date_ok'])) }})</span>
                                                        @endif
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <div class="text-xs text-gray-400 italic">Aucune tâche</div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Modal pour ajouter une nouvelle tâche -->
    @if ($showAddTaskModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50"
            wire:click="closeAddTaskModal">
            <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="mt-3">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Ajouter une nouvelle tâche</h3>
                        <button wire:click="closeAddTaskModal" class="text-gray-400 hover:text-gray-600">
                            <x-lucide-x class="w-6 h-6" />
                        </button>
                    </div>

                    <form wire:submit.prevent="saveTask">
                        <div class="mb-4">
                            <label for="task_user"
                                class="block text-sm font-medium text-gray-700 mb-2">Utilisateur</label>
                            <select id="task_user" wire:model="newTask.user_id" disabled
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Sélectionnez un utilisateur</option>
                                @foreach ($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                            @error('newTask.user_id')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-4">
                            <label for="task_project" class="block text-sm font-medium text-gray-700 mb-2">
                                <div class="flex items-center justify-between">
                                    <span>Projet</span>
                                    <button class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded"
                                        wire:click="openAddProjectModal">
                                        <x-lucide-plus class="w-4 h-4" />
                                    </button>
                                </div>
                            </label>
                            <select id="task_project" wire:model="newTask.project_id"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Sélectionnez un projet</option>
                                @foreach ($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->title }}</option>
                                @endforeach
                            </select>
                            @error('newTask.project_id')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-4">
                            <label for="task_title" class="block text-sm font-medium text-gray-700 mb-2">Titre de la
                                tâche</label>
                            <input type="text" id="task_title" wire:model="newTask.title"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                placeholder="Entrez le titre de la tâche">
                            @error('newTask.title')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-4">
                            <label for="task_description"
                                class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                            <textarea id="task_description" wire:model="newTask.description" rows="3"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                placeholder="Description de la tâche (optionnel)"></textarea>
                            @error('newTask.description')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="flex justify-end space-x-3">
                            <button type="button" wire:click="closeAddTaskModal"
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400">
                                Annuler
                            </button>
                            <button type="submit"
                                class="px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600">
                                Enregistrer
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <!-- Modal pour ajouter un nouveau projet -->
    @if ($showAddProjectModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50"
            wire:click="closeAddProjectModal">
            <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="mt-3">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Ajouter un nouveau projet</h3>
                        <button wire:click="closeAddProjectModal" class="text-gray-400 hover:text-gray-600">
                            <x-lucide-x class="w-6 h-6" />
                        </button>
                    </div>

                    <form wire:submit.prevent="saveProject">
                        <div class="mb-4">
                            <label for="project_title" class="block text-sm font-medium text-gray-700 mb-2">Titre du
                                projet</label>
                            <input type="text" id="project_title" wire:model="newProject.title"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                placeholder="Entrez le titre du projet">
                            @error('newProject.title')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="project_description"
                                class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                            <textarea id="project_description" wire:model="newProject.description" rows="3"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                                placeholder="Description du projet (optionnel)"></textarea>
                            @error('newProject.description')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="flex justify-end space-x-3">
                            <button type="button" wire:click="closeAddProjectModal"
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400">
                                Annuler
                            </button>
                            <button type="submit"
                                class="px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600">
                                Enregistrer
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
</div>
