<div>
    @if($project)
        <!-- Informations du projet -->
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
            <div class="p-6">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-900 mb-2">{{ $project->title }}</h1>
                        <p class="text-gray-600 mb-4">{{ $project->description }}</p>
                        <div class="flex items-center text-sm text-gray-500">
                            <span class="mr-4">Créé par: {{ $project->creator->name ?? 'Utilisateur inconnu' }}</span>
                            <span>Créé le: {{ $project->created_at->format('d/m/Y') }}</span>
                        </div>
                    </div>
                    <div class="text-right">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                            {{ $tasks->count() }} tâches
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Timeline des tâches -->
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Timeline des tâches</h2>
                
                @if($tasks->count() > 0)
                    <div class="space-y-6">
                        @foreach($tasks as $task)
                            <div class="relative pl-8 pb-6">
                                <!-- Ligne de timeline -->
                                @if(!$loop->last)
                                    <div class="absolute left-4 top-8 bottom-0 w-0.5 bg-gray-200"></div>
                                @endif
                                
                                <!-- Point de timeline -->
                                <div class="absolute left-0 top-2 w-8 h-8 rounded-full border-2 border-gray-300 bg-white flex items-center justify-center">
                                    @if($task->status === 'completed')
                                        <svg class="w-4 h-4 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                        </svg>
                                    @elseif($task->status === 'in_progress')
                                        <div class="w-3 h-3 bg-yellow-500 rounded-full"></div>
                                    @else
                                        <div class="w-3 h-3 bg-gray-400 rounded-full"></div>
                                    @endif
                                </div>
                                
                                <!-- Contenu de la tâche -->
                                <div class="bg-gray-50 rounded-lg p-4">
                                    <div class="flex justify-between items-start mb-2">
                                        <h3 class="text-lg font-medium text-gray-900">{{ $task->title }}</h3>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                            @if($task->status === 'completed') bg-green-100 text-green-800
                                            @elseif($task->status === 'in_progress') bg-yellow-100 text-yellow-800
                                            @else bg-gray-100 text-gray-800 @endif">
                                            @switch($task->status)
                                                @case('pending')
                                                    En attente
                                                    @break
                                                @case('in_progress')
                                                    En cours
                                                    @break
                                                @case('completed')
                                                    Terminé
                                                    @break
                                                @default
                                                    {{ $task->status }}
                                            @endswitch
                                        </span>
                                    </div>
                                    
                                    @if($task->description)
                                        <p class="text-gray-600 mb-3">{{ $task->description }}</p>
                                    @endif
                                    
                                    <div class="flex items-center justify-between text-sm text-gray-500">
                                        <div class="flex items-center space-x-4">
                                            <span>Assigné à: {{ $task->user->name ?? 'Non assigné' }}</span>
                                            <span>Ajouté le: {{ $task->date_ajout ? $task->date_ajout->format('d/m/Y') : 'N/A' }}</span>
                                            @if($task->date_ok)
                                                <span class="text-green-600">Terminé le: {{ $task->date_ok->format('d/m/Y') }}</span>
                                            @endif
                                        </div>
                                        <span class="text-xs">Créé par: {{ $task->creator->name ?? 'Utilisateur inconnu' }}</span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">Aucune tâche</h3>
                        <p class="mt-1 text-sm text-gray-500">Aucune tâche n'a été créée pour ce projet.</p>
                    </div>
                @endif
            </div>
        </div>
    @else
        <div class="text-center py-8">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-gray-900 mx-auto"></div>
            <p class="mt-4 text-gray-600">Chargement des détails du projet...</p>
        </div>
    @endif
</div>
