<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeders extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'name' => 'Libasse DIOP',
                'email' => 'libasse.diop@gmail.com',
                'password' => Hash::make('password'),
            ],
            [
                'name' => 'Ibra NDIAYE',
                'email' => 'ibra.ndiaye@gmail.com',
                'password' => Hash::make('password'),
            ],
            [
                'name' => 'Magor Sy',
                'email' => 'magor.sy@gmail.com',
                'password' => Hash::make('password'),
            ],
        ];
        foreach ($users as $user) {
            $item = User::where('email', $user['email'])->first();
            if (!$item) {
                $item = new User();
                $item->name = $user['name'];
                $item->email = $user['email'];
                $item->password = Hash::make('password');
                $item->save();
            }
        }
    }
}
