<?php

namespace Database\Seeders;

use App\Models\Task;
use App\Models\User;
use App\Models\Project;
use Illuminate\Database\Seeder;
use Carbon\Carbon;

class TaskSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::all();
        $projects = Project::all();

        if ($users->isEmpty()) {
            $this->command->info('Aucun utilisateur trouvé. Créez d\'abord des utilisateurs.');
            return;
        }

        if ($projects->isEmpty()) {
            $this->command->info('Aucun projet trouvé. Créez d\'abord des projets.');
            return;
        }

        $tasks = [
            // Tâches pour l'Application de Gestion de Tâches
            [
                'title' => 'Analyser les besoins utilisateurs',
                'description' => 'Conduire des entretiens avec les utilisateurs pour comprendre leurs besoins en gestion de tâches.',
                'status' => 'completed',
                'project_title' => 'Application de Gestion de Tâches',
            ],
            [
                'title' => 'Créer les maquettes UI/UX',
                'description' => 'Développer les wireframes et maquettes pour l\'interface utilisateur.',
                'status' => 'completed',
                'project_title' => 'Application de Gestion de Tâches',
            ],
            [
                'title' => 'Implémenter l\'authentification',
                'description' => 'Mettre en place le système d\'authentification avec Laravel Sanctum.',
                'status' => 'in_progress',
                'project_title' => 'Application de Gestion de Tâches',
            ],
            [
                'title' => 'Développer le CRUD des tâches',
                'description' => 'Créer les fonctionnalités de création, lecture, mise à jour et suppression des tâches.',
                'status' => 'pending',
                'project_title' => 'Application de Gestion de Tâches',
            ],

            // Tâches pour le Site E-commerce
            [
                'title' => 'Configurer la base de données',
                'description' => 'Créer les migrations et seeders pour les produits, commandes et utilisateurs.',
                'status' => 'completed',
                'project_title' => 'Site E-commerce',
            ],
            [
                'title' => 'Intégrer le système de paiement',
                'description' => 'Intégrer Stripe pour le traitement des paiements en ligne.',
                'status' => 'in_progress',
                'project_title' => 'Site E-commerce',
            ],
            [
                'title' => 'Développer le panier d\'achat',
                'description' => 'Créer le système de panier avec gestion des quantités et calcul des prix.',
                'status' => 'pending',
                'project_title' => 'Site E-commerce',
            ],

            // Tâches pour l'Application Mobile de Fitness
            [
                'title' => 'Concevoir l\'architecture mobile',
                'description' => 'Planifier l\'architecture de l\'application avec React Native.',
                'status' => 'completed',
                'project_title' => 'Application Mobile de Fitness',
            ],
            [
                'title' => 'Développer l\'API backend',
                'description' => 'Créer l\'API REST pour gérer les entraînements et les statistiques.',
                'status' => 'in_progress',
                'project_title' => 'Application Mobile de Fitness',
            ],
            [
                'title' => 'Implémenter le tracking GPS',
                'description' => 'Intégrer le suivi GPS pour les activités en extérieur.',
                'status' => 'pending',
                'project_title' => 'Application Mobile de Fitness',
            ],

            // Tâches pour le Système de Gestion de Projets
            [
                'title' => 'Analyser les exigences',
                'description' => 'Documenter les besoins fonctionnels et non fonctionnels.',
                'status' => 'completed',
                'project_title' => 'Système de Gestion de Projets',
            ],
            [
                'title' => 'Concevoir l\'interface utilisateur',
                'description' => 'Créer les maquettes et prototypes pour l\'interface d\'administration.',
                'status' => 'in_progress',
                'project_title' => 'Système de Gestion de Projets',
            ],
            [
                'title' => 'Développer le module de reporting',
                'description' => 'Créer les tableaux de bord et rapports pour le suivi des projets.',
                'status' => 'pending',
                'project_title' => 'Système de Gestion de Projets',
            ],

            // Tâches pour l'Application de Réservation
            [
                'title' => 'Modéliser la base de données',
                'description' => 'Créer le schéma de base de données pour les tables, menus et réservations.',
                'status' => 'completed',
                'project_title' => 'Application de Réservation',
            ],
            [
                'title' => 'Développer le calendrier de réservation',
                'description' => 'Créer l\'interface de calendrier pour la sélection des dates et heures.',
                'status' => 'in_progress',
                'project_title' => 'Application de Réservation',
            ],
            [
                'title' => 'Intégrer les notifications',
                'description' => 'Mettre en place les notifications par email et SMS pour les confirmations.',
                'status' => 'pending',
                'project_title' => 'Application de Réservation',
            ],

            // Tâches générales sans projet
            [
                'title' => 'Révision du code',
                'description' => 'Effectuer une revue de code sur les derniers développements.',
                'status' => 'completed',
                'project_title' => null,
            ],
            [
                'title' => 'Tests unitaires',
                'description' => 'Écrire les tests unitaires pour les nouvelles fonctionnalités.',
                'status' => 'in_progress',
                'project_title' => null,
            ],
            [
                'title' => 'Documentation technique',
                'description' => 'Rédiger la documentation technique du projet.',
                'status' => 'pending',
                'project_title' => null,
            ],
        ];

        foreach ($tasks as $taskData) {
            $existingTask = Task::where('title', $taskData['title'])->first();
            
            if (!$existingTask) {
                $user = $users->random();
                $creator = $users->random();
                $project = null;

                if ($taskData['project_title']) {
                    $project = $projects->where('title', $taskData['project_title'])->first();
                }

                $dateAjout = Carbon::now()->subDays(rand(1, 30));
                $dateOk = null;

                if ($taskData['status'] === 'completed') {
                    $dateOk = $dateAjout->copy()->addDays(rand(1, 7));
                }

                Task::create([
                    'title' => $taskData['title'],
                    'description' => $taskData['description'],
                    'date_ajout' => $dateAjout,
                    'date_ok' => $dateOk,
                    'status' => $taskData['status'],
                    'user_id' => $user->id,
                    'created_by' => $creator->id,
                    'project_id' => $project ? $project->id : null,
                ]);
            }
        }

        $this->command->info('Tâches créées avec succès !');
    }
} 