<?php

namespace Database\Seeders;

use App\Models\Project;
use App\Models\User;
use Illuminate\Database\Seeder;

class ProjectSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::all();

        if ($users->isEmpty()) {
            $this->command->info('Aucun utilisateur trouvé. Créez d\'abord des utilisateurs.');
            return;
        }

        $projects = [
            [
                'title' => 'Application de Gestion de Tâches',
                'description' => 'Développement d\'une application web moderne pour la gestion de tâches avec des fonctionnalités avancées comme les rappels, les priorités et les équipes.',
            ],
            [
                'title' => 'Site E-commerce',
                'description' => 'Création d\'une plateforme e-commerce complète avec système de paiement, gestion des stocks et interface d\'administration.',
            ],
            [
                'title' => 'Application Mobile de Fitness',
                'description' => 'Développement d\'une application mobile pour le suivi des entraînements, avec des plans personnalisés et des statistiques détaillées.',
            ],
            [
                'title' => 'Système de Gestion de Projets',
                'description' => 'Plateforme web pour la gestion de projets avec suivi des tâches, gestion des équipes et reporting avancé.',
            ],
            [
                'title' => 'Application de Réservation',
                'description' => 'Système de réservation en ligne pour un restaurant avec gestion des tables, menus et confirmations automatiques.',
            ],
        ];

        foreach ($projects as $projectData) {
            $item = Project::where('title', $projectData['title'])->first();
            if (!$item) {
                $item = Project::create([
                    'title' => $projectData['title'],
                    'description' => $projectData['description'],
                    'created_by' => $users->random()->id,
                ]);
            }
        }

        $this->command->info('Projets créés avec succès !');
    }
} 