<?php

namespace App\Livewire;

use App\Models\Project;
use App\Models\Task;
use Livewire\Component;

class ProjectDetails extends Component
{
    public $projectId;
    public $project;
    public $tasks;

    public function mount($projectId = null)
    {
        $this->projectId = $projectId ?? request()->route('project_id');
        $this->loadProject();
    }

    public function loadProject()
    {
        $this->project = Project::with(['creator', 'tasks' => function($query) {
            $query->orderBy('date_ajout', 'asc');
        }])->findOrFail($this->projectId);
        
        $this->tasks = $this->project->tasks;
    }

    public function render()
    {
        return view('livewire.project-details');
    }
}
